"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Bundler = exports.TEMP_FOLDER_NAME = exports.ES_6_FOLDER_NAME = exports.BUNDLER_DIRECTORY_PATH = exports.BUNDLED_FILE_NAME = void 0;
var fs = __importStar(require("fs-extra"));
var path = __importStar(require("path"));
var child_process_1 = require("child_process");
var glob_1 = require("glob");
var bundlerUtils_1 = require("./utils/bundlerUtils");
exports.BUNDLED_FILE_NAME = 'bundle.js';
exports.BUNDLER_DIRECTORY_PATH = './node_modules/@signageos/lib/dist/ESBuild/';
exports.ES_6_FOLDER_NAME = 'es6';
exports.TEMP_FOLDER_NAME = 'temp';
var Bundler = /** @class */ (function () {
    function Bundler(_a) {
        var outdir = _a.outdir, parameters = _a.parameters, serveOptions = _a.serveOptions, argv = _a.argv;
        this.DEFAULT_CHROME_VERSION = 32;
        this.serveOptions = {
            port: 3000,
        };
        // ts generates better types w/o typedef
        // eslint-disable-next-line @typescript-eslint/typedef
        this.esbuildOptions = {
            outdir: '',
            bundle: true,
            format: 'iife',
            logLevel: 'info',
            sourcemap: true,
            target: 'es6',
            treeShaking: true,
        };
        var config = (0, bundlerUtils_1.resolveConfig)({ outdir: outdir, parameters: parameters, argv: argv });
        (0, bundlerUtils_1.printBanner)(config);
        this.config = config;
        this.serveOptions = __assign(__assign({}, this.serveOptions), serveOptions);
        this.esbuildOptions = __assign(__assign({}, this.esbuildOptions), { outdir: outdir });
    }
    Bundler.copyAssetsToEs6Folder = function (expression) {
        if (expression === void 0) { expression = 'src/**/*.{sass,svg}'; }
        return __awaiter(this, void 0, void 0, function () {
            var files, copyPromises, error_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 3, , 4]);
                        return [4 /*yield*/, (0, glob_1.glob)(expression)];
                    case 1:
                        files = _a.sent();
                        copyPromises = files.map(function (file) {
                            // Calculate the destination path by replacing 'src' with 'es6'
                            var destinationPath = exports.ES_6_FOLDER_NAME + '/' + file.substr('src/'.length);
                            // Return a promise for copying the file
                            return fs.copy(file, destinationPath);
                        });
                        // Wait for all copy operations to finish
                        return [4 /*yield*/, Promise.all(copyPromises)];
                    case 2:
                        // Wait for all copy operations to finish
                        _a.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        error_1 = _a.sent();
                        console.error("Failed to copy assets to ES6 folder: ".concat(error_1));
                        throw error_1;
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    // Converts the input to a JSON string.
    Bundler.enc = function (x) {
        try {
            return x === undefined ? 'undefined' : JSON.stringify(x);
        }
        catch (error) {
            console.error("Failed to stringify JSON: ".concat(error));
            throw error;
        }
    };
    Bundler.prepareEs6Folder = function () {
        return __awaiter(this, void 0, void 0, function () {
            var error_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, fs.mkdir('./' + exports.ES_6_FOLDER_NAME, { recursive: true })];
                    case 1:
                        _a.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        error_2 = _a.sent();
                        console.error("Failed to prepare ES6 folder: ".concat(error_2));
                        throw error_2;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    // Bundles source files to `outdir` and watch & serve them in watch mode
    Bundler.prototype.build = function (ctx, watchInsteadOfServe) {
        if (watchInsteadOfServe === void 0) { watchInsteadOfServe = false; }
        return __awaiter(this, void 0, void 0, function () {
            var mode, serveOptions, error_3;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 5, , 6]);
                        mode = this.config.mode;
                        mode = mode === 'serve' && watchInsteadOfServe ? 'watch' : mode;
                        if (!(mode === 'watch' || mode === 'serve')) return [3 /*break*/, 2];
                        serveOptions = {
                            servedir: this.config.outdir,
                            port: this.serveOptions.port,
                        };
                        return [4 /*yield*/, (0, bundlerUtils_1.handleWatchMode)(ctx, mode, serveOptions)];
                    case 1:
                        _a.sent();
                        return [3 /*break*/, 4];
                    case 2: return [4 /*yield*/, (0, bundlerUtils_1.handleBuildMode)(ctx)];
                    case 3:
                        _a.sent();
                        _a.label = 4;
                    case 4: return [3 /*break*/, 6];
                    case 5:
                        error_3 = _a.sent();
                        console.error("Failed to build: ".concat(error_3));
                        throw error_3;
                    case 6: return [2 /*return*/];
                }
            });
        });
    };
    Bundler.prototype.compileTypescript = function (tscArgs, force) {
        if (tscArgs === void 0) { tscArgs = ['-p', 'tsconfig.es6.json']; }
        return __awaiter(this, void 0, void 0, function () {
            var shouldTypecheck, tsc_1, error_4;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        shouldTypecheck = force || this.config.typeCheck;
                        if (!shouldTypecheck) {
                            console.log('Skipping typescript compilation because of the --serve or --skipTypeCheck flag.');
                            return [2 /*return*/];
                        }
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        tsc_1 = (0, child_process_1.spawn)('tsc', tscArgs, { stdio: 'inherit' });
                        return [4 /*yield*/, new Promise(function (resolve, reject) {
                                tsc_1.on('close', function (code) { return __awaiter(_this, void 0, void 0, function () {
                                    return __generator(this, function (_a) {
                                        if (code !== 0) {
                                            reject(new Error("tsc process exited with code ".concat(code)));
                                        }
                                        else {
                                            resolve();
                                        }
                                        return [2 /*return*/];
                                    });
                                }); });
                                tsc_1.on('error', function (error) {
                                    reject(new Error("Failed to start tsc process: ".concat(error.message)));
                                });
                            })];
                    case 2:
                        _a.sent();
                        return [3 /*break*/, 4];
                    case 3:
                        error_4 = _a.sent();
                        console.error("Failed to compile TypeScript: ".concat(error_4));
                        throw error_4;
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    // Transpiles all js files in `outdir` to ES5 with SWC
    Bundler.prototype.transpileToES5 = function (options) {
        if (options === void 0) { options = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var error_5;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, (0, bundlerUtils_1.transpileToES5)({ outdir: this.config.outdir, options: options })];
                    case 1:
                        _a.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        error_5 = _a.sent();
                        console.error("Error during transpilation to ES5: ".concat(error_5));
                        throw error_5;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    // Writes index.html file to `outdir` folder and enables hot reload in the serve mode
    Bundler.prototype.writeIndexFile = function (source, destInOutdir, origin) {
        if (destInOutdir === void 0) { destInOutdir = 'index.html'; }
        if (origin === void 0) { origin = ''; }
        return __awaiter(this, void 0, void 0, function () {
            var dest, error_6;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        dest = path.resolve(this.config.outdir, destInOutdir);
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 7, , 8]);
                        console.info("Writing index file \"".concat(source, "\" to ").concat(dest));
                        return [4 /*yield*/, fs.promises.mkdir(this.config.outdir, { recursive: true })];
                    case 2:
                        _a.sent();
                        if (!['watch', 'serve'].includes(this.config.mode)) return [3 /*break*/, 4];
                        return [4 /*yield*/, (0, bundlerUtils_1.addLiveReloading)(source, dest, origin)];
                    case 3:
                        _a.sent();
                        return [3 /*break*/, 6];
                    case 4: return [4 /*yield*/, fs.promises.copyFile(source, dest)];
                    case 5:
                        _a.sent();
                        _a.label = 6;
                    case 6: return [3 /*break*/, 8];
                    case 7:
                        error_6 = _a.sent();
                        console.error("Failed to write index file: ".concat(error_6));
                        throw error_6;
                    case 8: return [2 /*return*/];
                }
            });
        });
    };
    Bundler.prototype.cleanOutDir = function (preservedFiles) {
        if (preservedFiles === void 0) { preservedFiles = [exports.BUNDLED_FILE_NAME, exports.BUNDLED_FILE_NAME + '.map']; }
        return __awaiter(this, void 0, void 0, function () {
            var files, _i, files_1, file, error_7;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 6, , 7]);
                        return [4 /*yield*/, fs.readdir(this.config.outdir)];
                    case 1:
                        files = _a.sent();
                        _i = 0, files_1 = files;
                        _a.label = 2;
                    case 2:
                        if (!(_i < files_1.length)) return [3 /*break*/, 5];
                        file = files_1[_i];
                        if (!!preservedFiles.includes(file)) return [3 /*break*/, 4];
                        return [4 /*yield*/, fs.rm(path.join(this.config.outdir, file), { recursive: true, force: true })];
                    case 3:
                        _a.sent();
                        _a.label = 4;
                    case 4:
                        _i++;
                        return [3 /*break*/, 2];
                    case 5: return [3 /*break*/, 7];
                    case 6:
                        error_7 = _a.sent();
                        console.error("Failed to clean dist folder: ".concat(error_7));
                        throw error_7;
                    case 7: return [2 /*return*/];
                }
            });
        });
    };
    return Bundler;
}());
exports.Bundler = Bundler;
//# sourceMappingURL=Bundler.js.map