"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDateTimeWithoutOffset = exports.isValidTimestamp = void 0;
var isValidTimestamp = function (timestamp) {
    if (!timestamp) {
        return false;
    }
    return !isNaN(timestamp) && timestamp > 0;
};
exports.isValidTimestamp = isValidTimestamp;
var getDateTimeWithoutOffset = function (dateTime) {
    var matcher = dateTime.match(/^(\d{4}-\d{2}-\d{2}[ T]\d{2}:\d{2}(:\d{2}(\.\d{3})?)?)/);
    return matcher && matcher[0];
};
exports.getDateTimeWithoutOffset = getDateTimeWithoutOffset;
//# sourceMappingURL=timestamp.js.map