"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.observeInterval = exports.wait = void 0;
function wait(window, timeout) {
    return new Promise(function (resolve) { return window.setTimeout(resolve, timeout); });
}
exports.wait = wait;
function observeInterval(window, interval) {
    return new Observable(function (observer) {
        var runningInterval = window.setInterval(function () { return observer.next(undefined); }, interval);
        return function () { return window.clearInterval(runningInterval); };
    });
}
exports.observeInterval = observeInterval;
//# sourceMappingURL=timer.js.map