"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getYearEnd = exports.getYearStart = exports.getMonthEnd = exports.getMonthStart = exports.getDayEnd = exports.getDayStart = void 0;
function getDayStart(year, month, day) {
    return new Date(year, month - 1, day, 0, 0, 0, 0);
}
exports.getDayStart = getDayStart;
function getDayEnd(year, month, day) {
    var d = getDayStart(year, month, day);
    d.setUTCHours(23, 59, 59, 999);
    return d;
}
exports.getDayEnd = getDayEnd;
function getMonthStart(year, month) {
    return getDayStart(year, month, 1);
}
exports.getMonthStart = getMonthStart;
function getMonthEnd(year, month) {
    var nextMonthStart = getMonthStart(year, month + 1);
    return new Date(nextMonthStart.getTime() - 1);
}
exports.getMonthEnd = getMonthEnd;
function getYearStart(year) {
    return getDayStart(year, 1, 1);
}
exports.getYearStart = getYearStart;
function getYearEnd(year) {
    return getDayEnd(year, 12, 31);
}
exports.getYearEnd = getYearEnd;
//# sourceMappingURL=statistics.js.map