"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPosixStringForYear = void 0;
var moment_timezone_1 = __importDefault(require("moment-timezone"));
function getPosixStringForYear(timezone, year) {
    var jan = moment_timezone_1.default.tz({ year: year, month: 0, day: 1 }, timezone);
    var jun = moment_timezone_1.default.tz({ year: year, month: 5, day: 1 }, timezone);
    var janOffset = jan.utcOffset();
    var junOffset = jun.utcOffset();
    var stdOffset = Math.min(janOffset, junOffset);
    var dltOffset = Math.max(janOffset, junOffset);
    var std = stdOffset === janOffset ? jan : jun;
    var dlt = dltOffset === janOffset ? jan : jun;
    var s = formatAbbreviationForPosix(std).concat(formatOffsetForPosix(stdOffset));
    if (stdOffset !== dltOffset) {
        s = s.concat(formatAbbreviationForPosix(dlt));
        if (dltOffset !== stdOffset + 60) {
            s = s.concat(formatOffsetForPosix(dltOffset));
        }
        s = s.concat(',').concat(formatTransitionForPosix(timezone, std));
        s = s.concat(',').concat(formatTransitionForPosix(timezone, dlt));
    }
    return s;
}
exports.getPosixStringForYear = getPosixStringForYear;
function formatAbbreviationForPosix(dateMoment) {
    var a = dateMoment.format('z');
    return /^[\+\-\d]+$/.test(a) ? '<'.concat(a).concat('>') : a;
}
function formatOffsetForPosix(offset) {
    // eslint-disable-next-line no-bitwise
    var h = (-offset / 60) | 0;
    var m = Math.abs(offset % 60);
    return h + (m === 0 ? '' : ':'.concat(m < 10 ? '0' : '').concat(m.toString()));
}
function formatTransitionForPosix(timezone, dateMoment) {
    var zone = moment_timezone_1.default.tz.zone(timezone);
    var ts = zone !== null ? zone.untils[zone._index(dateMoment)] : null;
    if (ts === null) {
        return 'J365/25';
    }
    var transition = zone !== null ? (0, moment_timezone_1.default)(ts).utcOffset(-zone.utcOffset(ts - 1)) : (0, moment_timezone_1.default)(ts);
    // eslint-disable-next-line no-bitwise
    var n = (((transition.date() - 1) / 7) | 0) + 1;
    var s = transition.format('[M]M.[n].d').replace('n', n.toString());
    var time = transition.format('[/]H:mm:ss').replace(/\:00$/, '').replace(/\:00$/, '');
    if (time !== '/2') {
        s = s.concat(time);
    }
    return s;
}
//# sourceMappingURL=posixTimezone.js.map