"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrentTimezoneOffset = exports.getCurrentTimezone = exports.now = void 0;
var moment_timezone_1 = __importDefault(require("moment-timezone"));
function now(timezoneOffsetHours) {
    if (!timezoneOffsetHours) {
        timezoneOffsetHours = getCurrentTimezone();
    }
    return (0, moment_timezone_1.default)().subtract(getCurrentTimezone(), 'hour').add(timezoneOffsetHours, 'hour');
}
exports.now = now;
function getCurrentTimezone() {
    return -(new Date().getTimezoneOffset() / 60);
}
exports.getCurrentTimezone = getCurrentTimezone;
function getCurrentTimezoneOffset() {
    return new Date().getTimezoneOffset();
}
exports.getCurrentTimezoneOffset = getCurrentTimezoneOffset;
//# sourceMappingURL=dateTimeFactory.js.map