import * as amqp from 'amqplib';
import ChannelProvider from './ChannelProvider';
import QueuePublisher from './QueuePublisher';
import QueueSubscriber from './QueueSubscriber';
import IAMQPPool from './IAMQPPool';
import { IOptions } from '../GenericPool/options';
import { IThirdPartyConnection } from '../ThirdParty/connection';
export interface IAMQPConnection extends IThirdPartyConnection {
    pool: IAMQPPool;
    channelProvider: ChannelProvider;
    queuePublisher: QueuePublisher;
    queueSubscriber: QueueSubscriber;
}
declare module 'amqplib' {
    interface Connection {
        isClosed: boolean;
    }
}
export declare function createAmqpConnection(dsn: string, options?: IOptions, onExit?: () => void, 
/**
 * Option to provide own factory
 *
 * Especially useful in tests for mocking the connection
 */
connectionFactory?: (dsn: string) => PromiseLike<amqp.Connection>): IAMQPConnection;
