"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.prepareAll = exports.deleteAll = exports.purgeAll = exports.fetchNextAutoSnapshot = exports.fetchNext = exports.bindAutoSnapshots = exports.bindAll = exports.process = exports.enqueue = exports.AUTO_SNAPSHOTS_QUEUE_NAME = exports.QUEUE_NAME = void 0;
var fetchNextMessage_1 = __importDefault(require("../fetchNextMessage"));
exports.QUEUE_NAME = 'commands';
exports.AUTO_SNAPSHOTS_QUEUE_NAME = 'auto_snapshots';
var DEFAULT_OPTIONS = {
    persistent: true,
    confirmable: false,
    maxPriority: 10,
};
function enqueue(amqpConnection, command, messageOptions) {
    if (messageOptions === void 0) { messageOptions = { priority: 5 }; }
    return __awaiter(this, void 0, void 0, function () {
        var createChannel;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    createChannel = function () { return __awaiter(_this, void 0, void 0, function () {
                        var channel;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.QUEUE_NAME, DEFAULT_OPTIONS)];
                                case 1:
                                    channel = _a.sent();
                                    return [4 /*yield*/, channel.assertExchange(exports.QUEUE_NAME, 'topic')];
                                case 2:
                                    _a.sent();
                                    return [2 /*return*/, channel];
                            }
                        });
                    }); };
                    return [4 /*yield*/, amqpConnection.queuePublisher.enqueue(createChannel, command, undefined, exports.QUEUE_NAME, exports.QUEUE_NAME, messageOptions)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.enqueue = enqueue;
function process(amqpConnection, command, messageOptions) {
    if (messageOptions === void 0) { messageOptions = { priority: 6 }; }
    return __awaiter(this, void 0, void 0, function () {
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.queuePublisher.enqueueExpectingResponse(function () { return __awaiter(_this, void 0, void 0, function () {
                        var channel;
                        return __generator(this, function (_a) {
                            switch (_a.label) {
                                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.QUEUE_NAME, DEFAULT_OPTIONS)];
                                case 1:
                                    channel = _a.sent();
                                    return [4 /*yield*/, channel.assertExchange(exports.QUEUE_NAME, 'topic')];
                                case 2:
                                    _a.sent();
                                    return [2 /*return*/, channel];
                            }
                        });
                    }); }, command, undefined, exports.QUEUE_NAME, exports.QUEUE_NAME, messageOptions)];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.process = process;
function bindAll(amqpConnection, options, onCommand) {
    return __awaiter(this, void 0, void 0, function () {
        var fullOptions;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    fullOptions = __assign(__assign({}, DEFAULT_OPTIONS), options);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeExpectingConfirmationRepeatable(function () { return __awaiter(_this, void 0, void 0, function () {
                            var channel;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.QUEUE_NAME, fullOptions)];
                                    case 1:
                                        channel = _a.sent();
                                        return [4 /*yield*/, channel.assertExchange(exports.QUEUE_NAME, 'topic')];
                                    case 2:
                                        _a.sent();
                                        return [2 /*return*/, channel];
                                }
                            });
                        }); }, exports.QUEUE_NAME, [{ exchangeName: exports.QUEUE_NAME, routingKey: exports.QUEUE_NAME, persistent: true }], function (command, _headers, ack, nack) { return __awaiter(_this, void 0, void 0, function () {
                            var response, error_1;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        _a.trys.push([0, 2, , 3]);
                                        return [4 /*yield*/, onCommand(command)];
                                    case 1:
                                        response = _a.sent();
                                        ack();
                                        return [2 /*return*/, response];
                                    case 2:
                                        error_1 = _a.sent();
                                        nack();
                                        throw error_1;
                                    case 3: return [2 /*return*/];
                                }
                            });
                        }); }, { autoDelete: false, respond: true })];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.bindAll = bindAll;
function bindAutoSnapshots(amqpConnection, options, onCommand) {
    return __awaiter(this, void 0, void 0, function () {
        var fullOptions;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    fullOptions = __assign(__assign({}, DEFAULT_OPTIONS), options);
                    return [4 /*yield*/, amqpConnection.queueSubscriber.subscribeExpectingConfirmationRepeatable(function () { return __awaiter(_this, void 0, void 0, function () {
                            var channel;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.AUTO_SNAPSHOTS_QUEUE_NAME, fullOptions)];
                                    case 1:
                                        channel = _a.sent();
                                        return [4 /*yield*/, channel.assertExchange(exports.QUEUE_NAME, 'topic')];
                                    case 2:
                                        _a.sent();
                                        return [2 /*return*/, channel];
                                }
                            });
                        }); }, exports.AUTO_SNAPSHOTS_QUEUE_NAME, [{ exchangeName: exports.QUEUE_NAME, routingKey: exports.QUEUE_NAME, persistent: true }], function (command, _headers, ack, nack) { return __awaiter(_this, void 0, void 0, function () {
                            var error_2;
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0:
                                        _a.trys.push([0, 2, , 3]);
                                        return [4 /*yield*/, onCommand(command)];
                                    case 1:
                                        _a.sent();
                                        ack();
                                        return [3 /*break*/, 3];
                                    case 2:
                                        error_2 = _a.sent();
                                        nack();
                                        throw error_2;
                                    case 3: return [2 /*return*/];
                                }
                            });
                        }); }, { autoDelete: false, durable: false, respond: false })];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.bindAutoSnapshots = bindAutoSnapshots;
function fetchNext(amqpConnection) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, (0, fetchNextMessage_1.default)(amqpConnection, exports.QUEUE_NAME, exports.QUEUE_NAME, exports.QUEUE_NAME, undefined, {
                        maxPriority: DEFAULT_OPTIONS.maxPriority,
                    })];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.fetchNext = fetchNext;
function fetchNextAutoSnapshot(amqpConnection) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, (0, fetchNextMessage_1.default)(amqpConnection, exports.AUTO_SNAPSHOTS_QUEUE_NAME, exports.QUEUE_NAME, exports.QUEUE_NAME, undefined, {
                        maxPriority: DEFAULT_OPTIONS.maxPriority,
                        durable: false,
                    })];
                case 1: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
exports.fetchNextAutoSnapshot = fetchNextAutoSnapshot;
function purgeAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function () {
        var channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.QUEUE_NAME)];
                case 1:
                    channel = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, , 5, 7]);
                    return [4 /*yield*/, channel.purge(exports.QUEUE_NAME)];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, channel.purge(exports.AUTO_SNAPSHOTS_QUEUE_NAME)];
                case 4:
                    _a.sent();
                    return [3 /*break*/, 7];
                case 5: return [4 /*yield*/, channel.close()];
                case 6:
                    _a.sent();
                    return [7 /*endfinally*/];
                case 7: return [2 /*return*/];
            }
        });
    });
}
exports.purgeAll = purgeAll;
function deleteAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function () {
        var channel;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, amqpConnection.channelProvider.getChannel(exports.QUEUE_NAME)];
                case 1:
                    channel = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, , 5, 7]);
                    return [4 /*yield*/, channel.delete(exports.QUEUE_NAME)];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, channel.delete(exports.AUTO_SNAPSHOTS_QUEUE_NAME)];
                case 4:
                    _a.sent();
                    return [3 /*break*/, 7];
                case 5: return [4 /*yield*/, channel.close()];
                case 6:
                    _a.sent();
                    return [7 /*endfinally*/];
                case 7: return [2 /*return*/];
            }
        });
    });
}
exports.deleteAll = deleteAll;
function prepareAll(amqpConnection) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: 
                // Hack to create event queue for exchange
                return [4 /*yield*/, fetchNext(amqpConnection)];
                case 1:
                    // Hack to create event queue for exchange
                    _a.sent();
                    return [4 /*yield*/, fetchNextAutoSnapshot(amqpConnection)];
                case 2:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.prepareAll = prepareAll;
//# sourceMappingURL=commandQueue.js.map