"use strict";
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var helper_exports = {};
__export(helper_exports, {
  detectIndent: () => detectIndent,
  getGroupedChangeLog: () => getGroupedChangeLog,
  getPipedInput: () => getPipedInput,
  readJSON: () => readJSON
});
module.exports = __toCommonJS(helper_exports);
var import_ChangeLogEntry = require("./ChangeLogEntry");
var import_fs = require("fs");
const VERSION_HEADER = "## ";
const CHANGES_HEADER = "### ";
const LOG_LINE = "- ";
const getPipedInput = function() {
  return new Promise((resolve, reject) => {
    let inputData;
    process.stdin.resume();
    process.stdin.setEncoding("utf8");
    process.stdin.on("data", (chunk) => inputData += chunk);
    process.stdin.on("end", () => resolve(inputData));
    process.stdin.on("error", (error) => reject(error));
  });
};
const getGroupedChangeLog = function(changeLog) {
  const newLines = changeLog.split(/\n|\r/).map((line) => line.trim()).filter((line) => line.startsWith(VERSION_HEADER) || line.startsWith(CHANGES_HEADER) || line.startsWith(LOG_LINE));
  const { groupedLog } = newLines.reduce(
    (reduction, line) => {
      var _a, _b;
      if (line.startsWith(VERSION_HEADER)) {
        const version = (_b = (_a = line.substring(VERSION_HEADER.length).match(/^\[?(([\d\w\.\-\+])+)\]?/)) == null ? void 0 : _a[1]) == null ? void 0 : _b.trim();
        if (version === void 0) {
          throw new Error(`Invalid version format "${version}"`);
        }
        if (reduction.groupedLog[version] !== void 0) {
          throw new Error(`The version "${version}" is duplicated in CHANGELOG`);
        }
        return __spreadProps(__spreadValues({}, reduction), {
          lastVersion: version,
          groupedLog: __spreadProps(__spreadValues({}, reduction.groupedLog), {
            [version]: {}
          })
        });
      } else if (line.startsWith(CHANGES_HEADER)) {
        const type = line.substring(CHANGES_HEADER.length).trim();
        const versionGroup = reduction.groupedLog[reduction.lastVersion];
        if (versionGroup === void 0 || reduction.lastVersion === null) {
          throw new Error(`The type "${type}" is not under any version section in CHANGELOG`);
        }
        if (!(0, import_ChangeLogEntry.isValidChangeLogEntry)(type)) {
          throw new Error(`Invalid type entry ${type}`);
        }
        if (versionGroup[type] !== void 0) {
          throw new Error(`The type "${type}" is duplicated at version "${reduction.lastVersion}" in CHANGELOG`);
        }
        return __spreadProps(__spreadValues({}, reduction), {
          lastType: type,
          groupedLog: __spreadProps(__spreadValues({}, reduction.groupedLog), {
            [reduction.lastVersion]: __spreadProps(__spreadValues({}, reduction.groupedLog[reduction.lastVersion]), {
              [type]: versionGroup[type] || []
            })
          })
        });
      } else {
        if (reduction.lastVersion === null) {
          throw new Error(`Line "${line}" is not under any version section in CHANGELOG`);
        }
        if (reduction.lastType === null) {
          throw new Error(`Line "${line}" is not under any type section in CHANGELOG`);
        }
        return __spreadProps(__spreadValues({}, reduction), {
          groupedLog: __spreadProps(__spreadValues({}, reduction.groupedLog), {
            [reduction.lastVersion]: __spreadProps(__spreadValues({}, reduction.groupedLog[reduction.lastVersion]), {
              [reduction.lastType]: [
                ...reduction.groupedLog[reduction.lastVersion][reduction.lastType],
                line.substring(LOG_LINE.length)
              ]
            })
          })
        });
      }
    },
    { groupedLog: {}, lastType: null, lastVersion: null }
  );
  return groupedLog;
};
const readJSON = (path) => import_fs.promises.readFile(path).then((b) => JSON.parse(b.toString()));
const detectIndent = (path) => __async(void 0, null, function* () {
  return /^\t/.test(yield import_fs.promises.readFile(path).then((b) => b.toString())) ? "	" : "  ";
});
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  detectIndent,
  getGroupedChangeLog,
  getPipedInput,
  readJSON
});
