#!/usr/bin/env node
"use strict";
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var import_fs = require("fs");
var import_helper = require("./helper");
function exactDepsMutable(deps, lock) {
  deps = deps || {};
  const depNames = Object.keys(deps);
  for (const depName of depNames) {
    const lockDep = lock.dependencies[depName];
    if (!lockDep) {
      throw new Error("package-lock.json is outdated");
    }
    const currentVersion = lockDep.version;
    deps[depName] = currentVersion;
  }
}
(() => __async(exports, null, function* () {
  const packagePath = process.cwd() + "/package.json";
  const packageLockPath = process.cwd() + "/package-lock.json";
  const pkg = yield (0, import_helper.readJSON)(packagePath);
  const packageLock = yield (0, import_helper.readJSON)(packageLockPath);
  exactDepsMutable(pkg.dependencies, packageLock);
  exactDepsMutable(pkg.devDependencies, packageLock);
  const indentChar = yield (0, import_helper.detectIndent)(packagePath);
  yield import_fs.promises.writeFile(packagePath, JSON.stringify(pkg, void 0, indentChar) + "\n");
}))();
