import { ServeOptions, BuildContext } from 'esbuild';
import { Options as swcOptions } from '@swc/core';
import { IBundlerConfig, IBundlerOptions } from './IBundler';
export declare const BUNDLED_FILE_NAME = "bundle.js";
export declare const BUNDLER_DIRECTORY_PATH = "./node_modules/@signageos/lib/dist/ESBuild/";
export declare const ES_6_FOLDER_NAME = "es6";
export declare const TEMP_FOLDER_NAME = "temp";
export declare class Bundler {
    readonly DEFAULT_CHROME_VERSION: number;
    readonly config: IBundlerConfig;
    readonly serveOptions: ServeOptions & {
        port: number;
    };
    readonly esbuildOptions: {
        readonly outdir: string;
        readonly bundle: true;
        readonly format: "iife";
        readonly logLevel: "info";
        readonly sourcemap: true;
        readonly target: "es6";
        readonly treeShaking: true;
    };
    constructor({ outdir, parameters, serveOptions, argv }: IBundlerOptions);
    static copyAssetsToEs6Folder(expression?: string): Promise<void>;
    static enc(x: any): string;
    static prepareEs6Folder(): Promise<void>;
    build(ctx: BuildContext, watchInsteadOfServe?: boolean): Promise<void>;
    compileTypescript(tscArgs?: string[], force?: boolean): Promise<void>;
    transpileToES5(options?: swcOptions): Promise<void>;
    writeIndexFile(source: string, destInOutdir?: string, origin?: string): Promise<void>;
    cleanOutDir(preservedFiles?: string[]): Promise<void>;
}
