// Sniffs the network for UDP packets sent by devices.
// UDP communication is used for synchronization between devices in local network
// so this script can be used to debug synchronization issues.
// eslint-disable-next-line prettier/prettier
const dgram = /** @type {import("dgram")}*/ require('dgram');

const PORT = 60539;

/** @param {Buffer} messageBuffer */
function handleMessage(messageBuffer) {
	const message = messageBuffer.toString();

	try {
		console.log('message', message);
	} catch (error) {
		console.warn(`failed to parse message from UDP socket; message = ${message}`);
	}
}

function createSocket() {
	const socket = dgram.createSocket({
		type: 'udp4',
		reuseAddr: true,
	});

	socket.addListener('message', handleMessage);
	socket.bind(PORT);

	return socket;
}

/** @param {import("dgram").Socket} socket */
async function open(socket) {
	await new Promise((resolve) => {
		socket.once('listening', () => {
			socket.setBroadcast(true);
			resolve(undefined);
		});
	});
}

(async () => {
	const socket = createSocket();
	await open(socket);
})();
