export class TextDecoder implements globalThis.TextDecoder {
	public readonly fatal: boolean;
	public readonly ignoreBOM: boolean;
	public readonly encoding: string;

	constructor(label?: string, options?: TextDecoderOptions) {
		console.warn('Using incomplete TextDecoder polyfill, this may cause non-standard behaviour.');

		this.encoding = label?.toLocaleLowerCase() ?? 'utf-8';
		this.fatal = options?.fatal ?? false;
		this.ignoreBOM = options?.ignoreBOM ?? false;
	}

	decode(input?: AllowSharedBufferSource | BufferSource, options?: TextDecodeOptions | undefined): string {
		if (options?.stream) {
			throw new Error('The stream option is not supported');
		}
		if (input === undefined) {
			return '';
		}
		if ('buffer' in input) {
			return Buffer.from(input.buffer, input.byteOffset, input.byteLength).toString(this.encoding as BufferEncoding);
		}

		return Buffer.from(input).toString(this.encoding as BufferEncoding);
	}
}
