import globalThis from '../ponyfill/globalThis';
let NativeResponse: (typeof window)['Response'];

export const getNativeResponse = () => NativeResponse ?? globalThis.Response;

export function polyfillFetch() {
	NativeResponse = globalThis.Response;

	const { fetch: whatwgFetch }: { fetch: typeof window.fetch } = require('whatwg-fetch'); // will polyfill if fetch is not available

	const originalFetch = globalThis.fetch;
	globalThis.fetch = function (input: RequestInfo, init?: RequestInit) {
		// native fetch does not work for "filesystem:" requests used internally by the "webkitFilesystem"
		if (isWebkitFileSystemUri(input)) {
			return whatwgFetch(input, init);
		}
		return originalFetch(input, init);
	};
}

function isWebkitFileSystemUri(input: RequestInfo) {
	const url = typeof input === 'string' ? input : input.url;
	return url.startsWith('filesystem:');
}
