import AppletTimingController from '../Front/AppletTiming/AppletTimingController';
import { ShowNextAppletTiming } from '../Front/AppletTiming/appletTimingActions';
import { ILoopModel } from '../Front/AppletTiming/appletTimingControllerSagas';
import IWebWorker from './IWebWorker';

export function createAppletTimingControllerWebWorker(
	postMessage: (message: ShowNextAppletTiming) => void,
): IWebWorker<ILoopModel, undefined> {
	const appletTimingController = new AppletTimingController(() => new Date().valueOf(), postMessage);
	return {
		start: () => appletTimingController.run(),
		onMessage: (model: ILoopModel) => appletTimingController.setModel(model),
	};
}
