import IVideoPlayer, { IPrepareOptions } from './IVideoPlayer';
import ProprietaryVideoPlayer from './ProprietaryVideoPlayer';
import HTMLVideo from './HTMLVideo';
import IVideoEventEmitter from './IVideoEventEmitter';

export default class HTMLVideoPlayer implements IVideoPlayer {
	private videos: HTMLVideo[];
	private videoPlayer: ProprietaryVideoPlayer;

	constructor(
		maxAllowedVideos: number,
		window: Window,
		foregroundWrapperElement: HTMLElement = window.document.body,
		backgroundWrapperElement?: HTMLElement,
		private getSystemVolume?: () => Promise<number>,
	) {
		this.videos = this.createVideos(maxAllowedVideos, window, foregroundWrapperElement, backgroundWrapperElement);
		this.videoPlayer = new ProprietaryVideoPlayer(this.videos);
	}

	public getMaxVideoCount(): number | null {
		return this.videoPlayer.getMaxVideoCount();
	}

	public async prepare(uri: string, x: number, y: number, width: number, height: number, options: IPrepareOptions = {}): Promise<void> {
		if (typeof options.volume === 'undefined' && this.getSystemVolume) {
			options.volume = await this.getSystemVolume();
		}
		await this.videoPlayer.prepare(uri, x, y, width, height, options);
	}

	public play(uri: string, x: number, y: number, width: number, height: number): Promise<IVideoEventEmitter> {
		return this.videoPlayer.play(uri, x, y, width, height);
	}

	public stop(uri: string, x: number, y: number, width: number, height: number): Promise<void> {
		return this.videoPlayer.stop(uri, x, y, width, height);
	}

	public pause(uri: string, x: number, y: number, width: number, height: number): Promise<void> {
		return this.videoPlayer.pause(uri, x, y, width, height);
	}

	public resume(uri: string, x: number, y: number, width: number, height: number): Promise<void> {
		return this.videoPlayer.resume(uri, x, y, width, height);
	}

	public clearAll(): Promise<void> {
		return this.videoPlayer.clearAll();
	}

	public setVolume(volume: number) {
		for (let video of this.videos) {
			video.setVolume(volume);
		}
	}

	public getDuration(uri: string, x: number, y: number, width: number, height: number) {
		return this.videoPlayer.getDuration(uri, x, y, width, height);
	}

	private createVideos(
		maxAllowedVideos: number,
		window: Window,
		foregroundWrapperElement: HTMLElement,
		backgroundWrapperElement?: HTMLElement,
	) {
		let videos: HTMLVideo[] = [];
		for (let i = 0; i < maxAllowedVideos; i++) {
			const video = new HTMLVideo(window, foregroundWrapperElement, backgroundWrapperElement);
			videos.push(video);
		}
		return videos;
	}
}
