import { IResponsibilities } from '../Feature/Responsibilities';
import Responsibility from '../Feature/Responsibility';
import IManagementDriver from '../NativeDevice/Management/IManagementDriver';
import ManagementCapabilities from '../NativeDevice/Management/ManagementCapability';
import { put, call } from 'redux-saga/effects';
import { bindAndTakeEveryOnlyWhenPlatform } from '../Socket/socketActionCreator';
import { SetDeviceConnectionToVPN, SetVPNSucceed, SetVPNFailed, PushVPNConfig } from '@signageos/actions/dist/Device/VPN/deviceVPNActions';

export function* setDeviceVPN(getNativeDriver: () => IManagementDriver, action: SetDeviceConnectionToVPN) {
	const nativeDriver = getNativeDriver();
	try {
		if (action.enabled) {
			yield nativeDriver.vpn.connect();
		} else {
			yield nativeDriver.vpn.disconnect();
		}

		yield put<SetVPNSucceed>({
			type: SetVPNSucceed,
			uid: action.uid,
		});
	} catch (error) {
		yield put<SetVPNFailed>({
			type: SetVPNFailed,
			uid: action.uid,
		});
	}
}

export function* vpnSaga(getNativeDriver: () => IManagementDriver, responsibilities: IResponsibilities) {
	if (!responsibilities.has(Responsibility.VPN)) {
		return;
	}

	const nativeDriver = getNativeDriver();
	const supportPRenabled: boolean = yield call([nativeDriver, 'managementSupports'], ManagementCapabilities.VPN);
	if (supportPRenabled) {
		yield bindAndTakeEveryOnlyWhenPlatform(SetDeviceConnectionToVPN, setDeviceVPN, getNativeDriver);

		yield bindAndTakeEveryOnlyWhenPlatform(PushVPNConfig, function* (action: PushVPNConfig) {
			try {
				yield nativeDriver.vpn.saveConfig(action.config);

				yield put<SetVPNSucceed>({
					type: SetVPNSucceed,
					uid: action.uid,
				});
			} catch (error) {
				yield put<SetVPNFailed>({
					type: SetVPNFailed,
					uid: action.uid,
				});
			}
		});
	}
}
