import DisplayPowerTimerResolver from './DisplayPowerTimerResolver';
import ProprietaryTimerResolver from './ProprietaryTimerResolver';
import { IProprietaryTimerStorage } from './ITimerStorage';
import { IResponsibilities } from '../Feature/Responsibilities';
import Responsibility from '../Feature/Responsibility';
import IProprietaryResolver, { DisplayEvent, TimerEvent, TimerListener } from './IProprietaryTimerResolver';

export const createProprietaryTimerManagerForManagement = (
	responsibilities: IResponsibilities,
	proprietaryTimerStorage: IProprietaryTimerStorage,
	displayIsPowerOn: () => Promise<boolean>,
) => {
	if (responsibilities.has(Responsibility.TIMERS)) {
		const storage = proprietaryTimerStorage;
		const proprietaryTimerResolver = new ProprietaryTimerResolver(storage);
		return new DisplayPowerTimerResolver(displayIsPowerOn, proprietaryTimerResolver, 30 * 1e3, storage, () => new Date());
	} else {
		return NotSupportedProprietaryTimerResolver;
	}
};

export const createProprietaryTimerManagerForFront = (
	responsibilities: IResponsibilities,
	proprietaryTimerStorage: IProprietaryTimerStorage,
) => {
	if (responsibilities.has(Responsibility.TIMERS)) {
		return new ProprietaryTimerResolver(proprietaryTimerStorage);
	} else {
		return NotSupportedProprietaryTimerResolver;
	}
};

export const NotSupportedProprietaryTimerResolver: IProprietaryResolver<TimerEvent | DisplayEvent> = {
	on(_event: any, _listener: TimerListener) {
		throw new Error('not supported');
	},
};
