import { NativeTimer } from '@signageos/common-types/dist/Device/Settings/DeviceSettings';
import NativeFromDriverTimer from '../NativeDevice/Timer/ITimer';
import { convertWeekday } from '@signageos/lib/dist/Timer/convertWeekday';
import NumberTimerType, { numberToNativeTimerType } from '../NativeDevice/Timer/TimerType';

/**
 * @deprecated use convertWeekday from `@signageos/lib/dist/Timer/convertWeekday`
 */
export function convertTimerToTimerPlain({ type, timeOn, timeOff, volume, weekdays }: NativeFromDriverTimer): NativeTimer {
	return {
		type: numberToNativeTimerType(type),
		timeOn,
		timeOff,
		weekdays: convertWeekday.fromTimerWeekday(weekdays).toShort(),
		volume,
	};
}

/**
 * @deprecated use convertWeekday from `@signageos/lib/dist/Timer/convertWeekday`
 */
export function convertTimerPlainToTimer({ type, timeOn, timeOff, volume, weekdays }: NativeTimer): NativeFromDriverTimer {
	return {
		type: NumberTimerType[type],
		timeOn,
		timeOff,
		weekdays: convertWeekday.fromShort(weekdays).toTimerWeekday(),
		volume,
	};
}
