import { put, takeEvery } from 'redux-saga/effects';
import { SocketDisconnected as SocketDisconnectedAction } from '@signageos/actions/dist/Socket/socketActions';
import { SocketConnected as SocketConnectedAction, SocketConnectionFailed as SocketConnectionFailedAction } from '../Socket/socketActions';
import { createSystemLogAction } from './systemLogActionFactory';
import { DeviceAlive as DeviceAliveAction } from '../Offline/offlineActions';
import {
	DeviceAlive,
	SocketConnected,
	SocketConnectionFailed,
	SocketDisconnected,
} from '@signageos/common-types/dist/Device/SystemLogs/systemLogs';

export function* commonSystemLogsSaga() {
	yield takeEvery(SocketConnectedAction, function* (): IterableIterator<any> {
		yield put(
			createSystemLogAction({
				type: SocketConnected,
			} satisfies SocketConnected),
		);
	});
	yield takeEvery(SocketDisconnectedAction, function* (): IterableIterator<any> {
		yield put(
			createSystemLogAction({
				type: SocketDisconnected,
			} satisfies SocketDisconnected),
		);
	});
	yield takeEvery(SocketConnectionFailedAction, function* (action: SocketConnectionFailedAction): IterableIterator<any> {
		yield put(
			createSystemLogAction({
				type: SocketConnectionFailed,
				errorMessage: action.errorMessage,
			} satisfies SocketConnectionFailed),
		);
	});
	yield takeEvery(DeviceAliveAction, function* (): IterableIterator<any> {
		yield put(
			createSystemLogAction({
				type: DeviceAlive,
			} satisfies DeviceAlive),
		);
	});
}
