import IDriver from '../../NativeDevice/Front/IFrontDriver';
import { SynchronizerType } from './IPolymorphicSynchronizer';
import ISynchronizer from '../ISynchronizer';
import { PolymorphicSynchronizer } from './PolymorphicSynchronizer';
import { createSocketSynchronizer } from '../SocketSynchronizer/socketSynchronizerFactory';

/**
 * Creates polymorphic synchronizer that uses socket synchronizer and P2P synchronizer.
 *
 * Socket synchronizer will be the default when connect() is called without specifying synchronizer type.
 *
 * TODO make P2P synchronizer the default once we decide that it is stable enough.
 */
export function createSocketAndP2PSynchronizer(
	socketSynchronizerServerUrl: string,
	getNativeDriver: () => IDriver,
	p2pSynchronizer: ISynchronizer,
) {
	const socketSynchronizer = createSocketSynchronizer(socketSynchronizerServerUrl, getNativeDriver);

	const synchronizerMap = new Map<SynchronizerType, ISynchronizer>();
	synchronizerMap.set(SynchronizerType.SyncServer, socketSynchronizer);
	synchronizerMap.set(SynchronizerType.P2PLocal, p2pSynchronizer);

	return new PolymorphicSynchronizer(synchronizerMap);
}
