import IStreamEvent from './IStreamEvent';
import { ITrackInfo } from './IStreamPlayer';

export interface IStreamErrorEvent extends IStreamEvent<'error'> {
	errorMessage: string;
}

export interface IStreamConnectedEvent extends IStreamEvent<'connected'> {}

export interface IStreamDisconnectedEvent extends IStreamEvent<'disconnected'> {}

export interface IStreamClosedEvent extends IStreamEvent<'closed'> {}

export interface IStreamReconnectEvent extends IStreamEvent<'reconnect'> {}

export interface IStreamTracksChangedEvent extends IStreamEvent<'tracks_changed'> {
	tracks: ITrackInfo[];
}
