import { bindAndTakeEvery } from './socketActionCreator';
import { put, takeEvery } from 'redux-saga/effects';
import wait from '@signageos/lib/dist/Timer/wait';
import { SocketDisconnected, PlatformConnect } from '@signageos/actions/dist/Socket/socketActions';
import { StartApplication } from '@signageos/actions/dist/Application/applicationActions';
import { SocketConnected, CheckSocketHealth } from './socketActions';
import IActionWithEmitter from '../Application/IActionWithEmitter';
import Debug from 'debug';

const debug = Debug('@signageos/front-display:Socket:socketHealthCheckSagas');

export function* healthChecking() {
	let platformUri: string;
	let socketDriver: string;
	let isSocketConnected = false;
	yield bindAndTakeEvery(PlatformConnect, function* (action: PlatformConnect): IterableIterator<any> {
		platformUri = action.platformUri;
		socketDriver = action.driver;
	});
	yield takeEvery(SocketConnected, function* (): IterableIterator<any> {
		debug('socket connected');
		isSocketConnected = true;
	});
	yield takeEvery(SocketDisconnected, function* (): IterableIterator<any> {
		debug('socket disconnected');
		isSocketConnected = false;
	});
	yield takeEvery(StartApplication, function* () {
		const RESPONSE_TIMEOUT = 60e3;
		yield wait(60 * 1e3);
		while (true) {
			try {
				if (isSocketConnected) {
					const checkSocketHealth: CheckSocketHealth & IActionWithEmitter = yield put({ type: CheckSocketHealth });
					yield new Promise<void>((resolve: () => void, reject: (error: Error) => void) => {
						const timoutHandler = setTimeout(() => reject(new Error('Action timed out')), RESPONSE_TIMEOUT);
						checkSocketHealth.__emitter.once('delivered', () => {
							clearTimeout(timoutHandler);
							resolve();
						});
					});
				} else {
					debug("don't check because socket isn't connected");
				}
			} catch (error) {
				debug('healthChecking failed. Try reconnect socket.', error);
				if (isSocketConnected) {
					yield put({
						type: PlatformConnect,
						platformUri: platformUri,
						driver: socketDriver,
					} as PlatformConnect);
				}
			} finally {
				yield wait(2 * 60 * 1e3);
			}
		}
	});
}
