import { Action } from 'redux';
import { put, PutEffect } from 'redux-saga/effects';
import IActionWithEmitter from '../Application/IActionWithEmitter';

export function* deliver<TAction extends Action>(
	action: TAction,
): Generator<PutEffect<TAction> | Promise<void>, TAction, IActionWithEmitter> {
	const actionWithEmitter: IActionWithEmitter = yield put<TAction>(action);
	yield new Promise((resolve: (value?: never) => void, reject: (e: Error) => void) => {
		const timeout = setTimeout(() => reject(new Error(`Delivering action ${action.type} has timed out`)), 10e3);
		actionWithEmitter.__emitter.once('delivered', () => {
			clearTimeout(timeout);
			resolve();
		});
	});
	return action;
}
