import NodeCache from 'node-cache';
import IAction from '@signageos/actions/dist/IAction';
import { OfflineActionsUploader } from '../Offline/OfflineActionsUploader';
import IOfflineAction from '@signageos/actions/dist/IOfflineAction';
import { ActionsLimit } from '@signageos/common-types/dist/Device/Actions/ActionLimit';

export class ThrottledActionsChecker {
	private cache: NodeCache;

	constructor(
		private actionUploader: OfflineActionsUploader,
		private readonly actionLimitMap: ActionsLimit,
	) {
		this.cache = new NodeCache({
			checkperiod: 5,
			deleteOnExpire: true,
			useClones: false,
		});
	}

	public async addActionOrPass(action: IAction<string> & IOfflineAction) {
		const key = `${action.type}`;

		if (this.actionLimitMap[action.type]) {
			const { limit, windowSecs: ttl } = this.actionLimitMap[action.type];
			if (this.cache.has(key)) {
				const counterObj: { counter: number } | undefined = this.cache.get(key);
				if (counterObj && counterObj.counter < limit) {
					// mutable update so ttl does not refresh
					counterObj.counter++;
					await this.actionUploader.addAction(action);
				}
			} else {
				this.cache.set(key, { counter: 1 }, ttl);
				await this.actionUploader.addAction(action);
			}
		}
	}
}
