import { IFilePath } from '../NativeDevice/fileSystem';

export interface IHealthcheckOptions {
	enabled: boolean;
	timeoutMs?: number;
}

export interface IServletOptions {
	env?: { [key: string]: any };
	healthcheck?: IHealthcheckOptions;
}

export interface IServletProcessMessage {
	type: string;
}

export interface IServletProcess {
	getId(): string;
	stop(): Promise<void>;
	onMessage(messageListener: (message: IServletProcessMessage) => void): () => void;
	onceClosed(listener: () => void): void;
	sendMessage<T extends IServletProcessMessage>(message: T): void;
}

interface IServletRunner {
	run(entryPoint: IFilePath, options?: IServletOptions): IServletProcess;
}

export default IServletRunner;
