import { waitForSuccessEventsOrFailEvents } from '../Events/eventsHelper';
import { CacheName } from './Cache';

export async function registerServiceWorker(window: Window) {
	if (!window.navigator.serviceWorker || !window.caches) {
		console.warn(`ServiceWorker or Cache API is not supported by this browser.`);
		return null;
	}
	const [registration] = await Promise.all([registerAndUpdateServiceWorker(window.navigator.serviceWorker), cacheAppFiles(window.caches)]);
	return registration;
}

async function registerAndUpdateServiceWorker(serviceWorkerContainer: ServiceWorkerContainer) {
	await waitForSuccessEventsOrFailEvents(window, ['load'], []);
	const registration = await serviceWorkerContainer.register('./serviceWorker.js', {
		updateViaCache: 'all',
	});
	console.info('ServiceWorker registration successful with scope: ', registration.scope);
	try {
		await registration.update();
	} catch (error) {
		console.error('ServiceWorker registration update failed: ', error);
	}
	return registration;
}

async function cacheAppFiles(caches: CacheStorage) {
	const cache = await caches.open(CacheName.FrontDisplay);
	const cachePaths = [
		'./',
		'index.html',
		'webWorker.js',
		//'osd/*', // TODO add into cache all files in osd folder
	];
	await Promise.all(
		cachePaths.map((cachePath) =>
			cache.add(cachePath).catch((error) => console.warn(`Failed to fetch "${cachePath}". Continue online.`, error)),
		),
	);
}
