import { EventEmitter } from 'events';
import IProximitySensor from '../NativeDevice/Sensors/IProximitySensor';

export default class MockProximitySensor implements IProximitySensor {
	private eventEmitter: EventEmitter;
	private mouseInsideWindow: boolean = false;

	constructor(private window: Window) {
		this.eventEmitter = new EventEmitter();
		this.listenToMouseEvents();
	}

	public addStateChangeListener(callback: (detected: boolean) => void): void {
		this.eventEmitter.addListener('change', callback);
	}

	public removeStateChangeListener(callback: (detected: boolean) => void): void {
		this.eventEmitter.removeListener('change', callback);
	}

	private listenToMouseEvents() {
		this.window.document.addEventListener('mouseenter', () => {
			if (!this.mouseInsideWindow) {
				this.mouseInsideWindow = true;
				this.eventEmitter.emit('change', true);
			}
		});
		this.window.document.addEventListener('mouseout', (event: MouseEvent) => {
			const fromElement = event.relatedTarget as HTMLElement;
			if (!fromElement || fromElement.nodeName === 'HTML') {
				this.mouseInsideWindow = false;
				this.eventEmitter.emit('change', false);
			}
		});
	}
}
