import AsyncStorage from '../Storage/Async/AsyncStorage';

const OVERLAY_SHOWN_KEY = 'Screen.Overlay.Shown';

export async function isOverlayShown(storage: AsyncStorage) {
	return (await storage.getItem(OVERLAY_SHOWN_KEY)) === '1';
}

export async function hideOverlay(window: Window, storage: AsyncStorage) {
	await storage.removeItem(OVERLAY_SHOWN_KEY);
	await updateOverlay(window, storage);
}

export async function showOverlay(window: Window, storage: AsyncStorage) {
	await storage.setItem(OVERLAY_SHOWN_KEY, '1');
	await updateOverlay(window, storage);
}

export async function updateOverlay(window: Window, storage: AsyncStorage) {
	const overlayShown = await storage.getItem(OVERLAY_SHOWN_KEY);
	const overlayId = 'screen-overlay';
	if (!overlayShown) {
		const overlay = window.document.getElementById(overlayId);
		if (overlay && overlay.parentElement) {
			overlay.parentElement.removeChild(overlay);
		}
	} else {
		const existingOverlay = window.document.getElementById(overlayId);
		if (!existingOverlay) {
			const overlay = window.document.createElement('div');
			overlay.setAttribute('id', overlayId);
			overlay.style.backgroundColor = '#000000';
			overlay.style.position = 'absolute';
			overlay.style.left = '0';
			overlay.style.top = '0';
			overlay.style.width = '100%';
			overlay.style.height = '100%';
			overlay.style.zIndex = '99999';
			window.document.body.appendChild(overlay);
		}
	}
}
