import { Action } from 'redux';
import { ActionPattern, fork, StrictEffect, takeEvery } from 'redux-saga/effects';
import { ChangeSubscriptionToOpen, ChangeSubscriptionToPlatform } from '../Device/Configuration/deviceConfigurationActions';
import { SubscriptionType } from '../Display/IConfig';
import { SagaIterator } from 'redux-saga';

export type SagaIteratorWithPromises<Return = void, Yield = any, ExtraYield = never> = Iterator<
	Promise<any> | StrictEffect | SagaIterator | ExtraYield,
	Return,
	Yield
>;

export function takeEveryIfOpen<TAction extends Action>(
	pattern: ActionPattern<TAction>,
	worker: (action: TAction) => SagaIteratorWithPromises,
) {
	return takeEveryIfSubscriptionType(SubscriptionType.open, pattern, worker);
}

export function takeEveryIfPlatform<TAction extends Action>(
	pattern: ActionPattern<TAction>,
	worker: (action: TAction) => SagaIteratorWithPromises,
) {
	return takeEveryIfSubscriptionType(SubscriptionType.platform, pattern, worker);
}

function takeEveryIfSubscriptionType<TAction extends Action>(
	subscriptionType: SubscriptionType,
	pattern: ActionPattern<TAction>,
	worker: (action: TAction) => SagaIteratorWithPromises,
) {
	return fork(function* () {
		let currentSubscription: SubscriptionType = SubscriptionType.open;
		yield takeEvery(ChangeSubscriptionToOpen, function* (): IterableIterator<any> {
			currentSubscription = SubscriptionType.open;
		});
		yield takeEvery(ChangeSubscriptionToPlatform, function* (): IterableIterator<any> {
			currentSubscription = SubscriptionType.platform;
		});

		yield takeEvery(pattern, function* (action: TAction): IterableIterator<any> {
			if (subscriptionType === currentSubscription) {
				yield worker(action);
			}
		});
	});
}
