import { ITcpSocket } from './ITcpSocket';
import { TcpSocket } from './TcpSocket';

export async function tcpSocketFactory({
	port,
	clientConnectionTimeoutMs,
}: {
	port: number;
	clientConnectionTimeoutMs?: number;
}): Promise<ITcpSocket<Buffer>> {
	const socket = new TcpSocket({ port, clientConnectionTimeoutMs });
	await socket.open();
	return socket;
}
