export function parseMessage(messageString: string): object | null {
	try {
		const message = JSON.parse(messageString);
		return typeof message === 'object' ? message : null;
	} catch (error) {
		// failed to parse so it's not a Message and we can ignore it
		return null;
	}
}

export interface ISerializer<TSerialized> {
	serialize(message: object): TSerialized;
	deserialize(messageBuffer: TSerialized): object | null;
}

export const IdentitySerializer: ISerializer<object> = {
	serialize: (object) => object,
	deserialize: (message) => message,
};
