import { ISerializer, parseMessage } from './serialization';

export class NodeSocketSerializer implements ISerializer<Buffer> {
	public serialize(message: object): Buffer {
		const encodedMessage = JSON.stringify(message);
		return this.convertToBuffer(encodedMessage);
	}

	public deserialize(buffer: Buffer): object | null {
		const messageString = buffer.toString();
		return parseMessage(messageString);
	}

	private convertToBuffer(data: string) {
		const nodeVersionMatch = process.version.match(/^v(\d)/);
		const nodeVersion = (nodeVersionMatch && parseInt(nodeVersionMatch[1])) || null;

		// Buffer.from was added in NodeJS 5.10.0 but some platforms we have to support have older NodeJS version than that.
		// Also new Buffer is deprecated since version 6.
		// This is the easiest way to ensure support for all versions.
		if (nodeVersion && nodeVersion >= 6) {
			return Buffer.from(data);
		} else {
			return new Buffer(data as string);
		}
	}
}
