import { networkInterfaces } from 'os';

export async function getLocalAddress() {
	const interfaces = networkInterfaces();

	for (const interfaceName in interfaces) {
		const subInterface = interfaces[interfaceName];
		if (subInterface !== undefined) {
			for (const { address, internal, family } of subInterface) {
				if (!internal && family === 'IPv4') {
					return address;
				}
			}
		}
	}

	return null;
}
