import Orientation from '@signageos/common-types/dist/Device/Resolution/Orientation';
import VideoOrientation from '@signageos/common-types/dist/Device/Resolution/VideoOrientation';

const ORIENTATION_KEY = 'local-config-ORIENTATION_KEY';
const VIDEO_ORIENTATION_KEY = 'local-config-VIDEO_ORIENTATION_KEY';
const ORIENTATION_PORTRAIT_VALUE = 'local-config-ORIENTATION_PORTRAIT_VALUE';
const ORIENTATION_LANDSCAPE_FLIPPED_VALUE = 'local-config-ORIENTATION_LANDSCAPE_FLIPPED_VALUE';
const ORIENTATION_PORTRAIT_FLIPPED_VALUE = 'local-config-ORIENTATION_PORTRAIT_FLIPPED_VALUE';
const VIDEO_ORIENTATION_LANDSCAPE_VALUE = 'local-config-VIDEO_ORIENTATION_LANDSCAPE_VALUE';
const VIDEO_ORIENTATION_LANDSCAPE_FLIPPED_VALUE = 'local-config-VIDEO_ORIENTATION_LANDSCAPE_FLIPPED_VALUE';

export function setOrientation(storage: Storage, orientation: Orientation, videoOrientation?: VideoOrientation) {
	let contentOrientationValue: string | undefined = undefined;
	let videoOrientationValue: string | undefined = undefined;

	switch (orientation) {
		case Orientation.PORTRAIT:
			contentOrientationValue = ORIENTATION_PORTRAIT_VALUE;
			break;
		case Orientation.LANDSCAPE:
			break;
		case Orientation.PORTRAIT_FLIPPED:
			contentOrientationValue = ORIENTATION_PORTRAIT_FLIPPED_VALUE;
			break;
		case Orientation.LANDSCAPE_FLIPPED:
			contentOrientationValue = ORIENTATION_LANDSCAPE_FLIPPED_VALUE;
			break;
		default:
			throw new Error('Invalid orientation');
	}

	switch (videoOrientation) {
		case VideoOrientation.LANDSCAPE:
			videoOrientationValue = VIDEO_ORIENTATION_LANDSCAPE_VALUE;
			break;
		case VideoOrientation.LANDSCAPE_FLIPPED:
			videoOrientationValue = VIDEO_ORIENTATION_LANDSCAPE_FLIPPED_VALUE;
			break;
		default:
	}

	if (contentOrientationValue) {
		storage.setItem(ORIENTATION_KEY, contentOrientationValue);
	} else {
		storage.removeItem(ORIENTATION_KEY);
	}

	if (videoOrientationValue) {
		storage.setItem(VIDEO_ORIENTATION_KEY, videoOrientationValue);
	} else {
		storage.removeItem(VIDEO_ORIENTATION_KEY);
	}
}

export function getOrientation(storage: Storage) {
	const orientation = storage.getItem(ORIENTATION_KEY);
	switch (orientation) {
		case ORIENTATION_PORTRAIT_VALUE:
			return Orientation.PORTRAIT;
		case ORIENTATION_PORTRAIT_FLIPPED_VALUE:
			return Orientation.PORTRAIT_FLIPPED;
		case ORIENTATION_LANDSCAPE_FLIPPED_VALUE:
			return Orientation.LANDSCAPE_FLIPPED;
		default:
			return Orientation.LANDSCAPE;
	}
}

export function getVideoOrientation(storage: Storage) {
	const orientation = storage.getItem(VIDEO_ORIENTATION_KEY);
	switch (orientation) {
		case VIDEO_ORIENTATION_LANDSCAPE_VALUE:
			return VideoOrientation.LANDSCAPE;
		case VIDEO_ORIENTATION_LANDSCAPE_FLIPPED_VALUE:
			return VideoOrientation.LANDSCAPE_FLIPPED;
		default:
			return null;
	}
}
