import moment from 'moment-timezone';

export function resolveCurrentBrightness(timeFrom1: string, brightness1: number, timeFrom2: string, brightness2: number, now: Date) {
	const nowMoment = moment(now);
	let timeFrom1Moment = moment(nowMoment.format('YYYY-MM-DD') + ' ' + timeFrom1, 'YYYY-MM-DD HH:mm:ss');
	let timeFrom2Moment = moment(nowMoment.format('YYYY-MM-DD') + ' ' + timeFrom2, 'YYYY-MM-DD HH:mm:ss');

	if (timeFrom2Moment.isBefore(timeFrom1Moment)) {
		[timeFrom1Moment, brightness1, timeFrom2Moment, brightness2] = [timeFrom2Moment, brightness2, timeFrom1Moment, brightness1]; // swap
	}

	if (nowMoment.isSameOrAfter(timeFrom1Moment) && nowMoment.isBefore(timeFrom2Moment)) {
		return brightness1;
	}

	return brightness2;
}
