export function convertClientCoordinatesToSystem(
	window: Window,
	angle: number,
	x: number,
	y: number,
	width: number,
	height: number,
): { x: number; y: number; width: number; height: number } {
	switch (angle) {
		case 0:
			return { x, y, width, height };
		case 90:
			return {
				x: window.innerWidth - (y + height),
				y: x,
				width: height,
				height: width,
			};
		case 180:
			return {
				x: window.innerWidth - (x + width),
				y: window.innerHeight - (y + height),
				width,
				height,
			};
		case 270:
			return {
				x: y,
				y: window.innerHeight - (x + width),
				width: height,
				height: width,
			};
		default:
			throw new Error('unsupported angle');
	}
}
