import IPowerActionTimer, { PowerActionRule } from './IPowerActionTimer';

/**
 * @param filter Which power actions to unschedule.
 * @returns Whether any power actions were unscheduled.
 */
export async function unsetByFilter(timer: IPowerActionTimer, filter: (rule: PowerActionRule) => boolean): Promise<boolean> {
	const rules = await timer.rules();
	const uidsToUnset = Object.entries(rules)
		.filter(([_key, value]: [string, PowerActionRule]) => filter(value))
		.reduce((uids: string[], [key, _value]: [string, PowerActionRule]) => [...uids, key], []);
	const hasUidsToUnset = uidsToUnset.length > 0;
	if (hasUidsToUnset) {
		timer.unset(...uidsToUnset);
	}
	return hasUidsToUnset;
}
