export enum SerialPortEvent {
	DATA = 'data',
	CLOSE = 'close',
}

export interface ISerialPort {
	on(event: SerialPortEvent.DATA, listener: (data: Uint8Array) => void): void;
	on(event: SerialPortEvent.CLOSE, listener: () => void): void;
	removeListener(event: SerialPortEvent.DATA, listener: (data: Uint8Array) => void): void;
	removeListener(event: SerialPortEvent.CLOSE, listener: () => void): void;
	removeAllListeners(event?: SerialPortEvent): void;
	write(data: string | number[] | Uint8Array): Promise<void>;
	close(): Promise<void>;
}

export enum Parity {
	NONE = 'none',
	EVEN = 'even',
	MARK = 'mark',
	ODD = 'odd',
	SPACE = 'space',
}

export interface IOptions {
	device?: string;
	baudRate: number;
	parity?: Parity;
	databits?: number;
	stopbits?: number;
	rtscts?: boolean;
}

interface ISerial {
	openPort(options: IOptions): Promise<ISerialPort>;
	closeAll(): Promise<void>;
}

export default ISerial;
