export class NotSupportedMethodError extends Error {
	constructor(methodName: string) {
		super(`${methodName} is not supported`);
		// https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
		Object.setPrototypeOf(this, NotSupportedMethodError.prototype);
	}
}
