import Cookies from 'js-cookie';
import url from 'url';

export const getEmulatorUid = (href: string): string => {
	const currentLocation = url.parse(href, true);
	if (currentLocation.query?.duid) {
		return [currentLocation.query.duid].flat()[0];
	} else if (!Cookies.get('DUID')) {
		const fakeDuid = '' + Math.random();

		Cookies.set('DUID', fakeDuid, {
			expires: 10 * 365,
		});
		return fakeDuid;
	} else {
		return Cookies.get('DUID');
	}
};
