import ICacheDriver from '../ICacheDriver';
import ICacheStorageInfo from '../ICacheStorageInfo';

export class InMemoryCacheDriver implements ICacheDriver {
	private map: Map<string, string> = new Map<string, string>();

	public async cacheGetUids() {
		return [...this.map.keys()];
	}

	public async cacheGetAll() {
		return [...this.map.entries()].reduce<{ [uid: string]: string }>((acc, [uid, value]) => {
			acc[uid] = value;
			return acc;
		}, {});
	}

	public async cacheGet(uid: string) {
		const value = this.map.get(uid);
		if (!value) {
			throw new Error(`Cache value for uid ${uid} not found`);
		}
		return value;
	}

	public async cacheDelete(uid: string) {
		this.map.delete(uid);
	}

	public async cacheSave(uid: string, content: string) {
		this.map.set(uid, content);
	}

	public async cacheGetStorageInfo(): Promise<ICacheStorageInfo> {
		throw new Error('Not implemented');
	}
}
