import IMonitors, { IMonitor } from '../NativeDevice/IMonitors';

export default class MockMonitors implements IMonitors {
	constructor(private window: Window) {}

	public async getList(): Promise<IMonitor[]> {
		return [
			{
				manufacturer: this.window.navigator.vendor || this.window.navigator.appCodeName, // firefox doesn't have vendor
				model: this.window.navigator.userAgent,
				serial: this.window.navigator.productSub,
				firmware: this.window.navigator.appVersion,
			},
		];
	}
}
