import ICacheDriver from '../NativeDevice/ICacheDriver';
import IManagementDriver from '../NativeDevice/Management/IManagementDriver';

/** It clears the browser cookies, clears the persistent file system, and reboots the device */
export async function fileSystemWipeoutAction(managementDriver: IManagementDriver, cacheDriver: ICacheDriver) {
	try {
		await clearCookies(window);
		await clearCache(cacheDriver);
		await managementDriver.fileSystem.wipeout();
	} catch (error) {
		console.warn('fileSystemWipeoutAction failed', error);
	}
}

/** It deletes all cookies by setting their expiration date to the past */
async function clearCookies(window: Window) {
	try {
		let cookies = window.document.cookie.split('; ');
		for (let id = 0; id < cookies.length; id++) {
			let domain = window.location.hostname.split('.');
			while (domain.length > 0) {
				let cookieBase =
					encodeURIComponent(cookies[id].split(';')[0].split('=')[0]) +
					'=; expires=Thu, 01-Jan-1970 00:00:01 GMT; domain=' +
					domain.join('.') +
					' ;path=';
				let path = location.pathname.split('/');
				document.cookie = cookieBase + '/';
				while (path.length > 0) {
					document.cookie = cookieBase + path.join('/');
					path.pop();
				}
				domain.shift();
			}
		}
	} catch (error) {
		console.error('managementHelper - clearCookies failed', error);
	}
}

/**
 * "Clear the cache by deleting all the keys in the cache."
 * @param nativeDriver - ICacheDriver
 */
async function clearCache(nativeDriver: ICacheDriver): Promise<void> {
	try {
		const uids = await nativeDriver.cacheGetUids();
		await Promise.allSettled(
			uids.map(async (uid: string) => {
				await nativeDriver.cacheDelete(uid);
			}),
		);
	} catch (error) {
		console.error('managementHelper - clearCache failed', error);
	}
}
