import * as t from './../../Test/TestFramework';
import IManagementDriver from '../../NativeDevice/Management/IManagementDriver';
import should from '../../Test/should';
import ManagementCapability from '../../NativeDevice/Management/ManagementCapability';
import { TestCase } from '@signageos/actions/dist/Device/Test/deviceTestActions';
import { IResponsibilities } from '../../Feature/Responsibilities';
import Responsibility from '../../Feature/Responsibility';

export default async (nativeDriver: IManagementDriver, responsibilities: IResponsibilities) => {
	return t.describe(TestCase.DISPLAY, function* () {
		yield t.it('Should power on/off display', async () => {
			if (!responsibilities.has(Responsibility.POWER)) {
				// Android app can't test display power ON/OFF automatically.
				// Test runs inside WebView and the WebView is unloaded on display OFF.
				// This is an abuse of Responsibility.POWER and a hack!
				t.skip(`Power management tests are disabled on this device.`);
			}
			if (!(await nativeDriver.managementSupports(ManagementCapability.DISPLAY_POWER))) {
				t.skip(`The device does not provide "${ManagementCapability.DISPLAY_POWER}" capability`);
			}

			const isOn = await nativeDriver.displayIsPowerOn();
			if (isOn) {
				await nativeDriver.displayPowerOff();
				should(await nativeDriver.displayIsPowerOn()).be.false();
				await nativeDriver.displayPowerOn();
				should(await nativeDriver.displayIsPowerOn()).be.true();
			} else {
				await nativeDriver.displayPowerOn();
				should(await nativeDriver.displayIsPowerOn()).be.true();
				await nativeDriver.displayPowerOff();
				should(await nativeDriver.displayIsPowerOn()).be.false();
			}
		});

		yield t.it('Should set the screen brightness', async () => {
			if (!(await nativeDriver.managementSupports(ManagementCapability.SET_BRIGHTNESS))) {
				t.skip(`The device does not provide "${ManagementCapability[ManagementCapability.SET_BRIGHTNESS]}" capability`);
			}

			const br = await nativeDriver.screenGetBrightness();
			should(br).be.ok();
			should.exist(br.timeFrom1);
			should.exist(br.brightness1);
			should.exist(br.timeFrom2);
			should.exist(br.brightness2);

			await nativeDriver.screenSetBrightness('00:00:00', 90, '23:59:59', 30);
			if (await nativeDriver.managementSupports(ManagementCapability.BRIGHTNESS_SCHEDULING)) {
				// Some platforms do not returns seconds in the time string
				const newBrightness = await nativeDriver.screenGetBrightness();
				should(newBrightness).be.ok();
				should(newBrightness.timeFrom1).containEql('00:00');
				should(newBrightness.brightness1).equal(90);
				should(newBrightness.timeFrom2).containEql('23:59');
				should(newBrightness.brightness2).equal(30);
			} else {
				const newBrightness = await nativeDriver.screenGetBrightness();
				should(newBrightness.brightness1).equal(90);
			}

			await nativeDriver.screenSetBrightness(br.timeFrom1, br.brightness1, br.timeFrom2, br.brightness2);
		});
	});
};
