import should from '../../Test/should';
import * as t from './../../Test/TestFramework';
import IManagementDriver from '../../NativeDevice/Management/IManagementDriver';
import { TestCase } from '@signageos/actions/dist/Device/Test/deviceTestActions';
import ManagementCapability from '../../NativeDevice/Management/ManagementCapability';

export default async (nativeDriver: IManagementDriver) => {
	return t.describe(TestCase.DEBUG, function* () {
		yield t.beforeEach('skip if debug not provided', async () => {
			if (!(await nativeDriver.managementSupports(ManagementCapability.SET_DEBUG))) {
				t.skip(`The device does not provide "${ManagementCapability[ManagementCapability.SET_DEBUG]}" capability`);
			}
		});

		yield t.it('Should set native debug on', async () => {
			await nativeDriver.setDebug(true);
			should(await nativeDriver.isDebugEnabled()).be.true("expected debug to be enabled but it's disabled");
		});

		yield t.it('Should set native debug off', async () => {
			await nativeDriver.setDebug(false);
			should(await nativeDriver.isDebugEnabled()).be.false("expected debug to be disabled but it's enabled");
		});
	});
};
