import * as t from './../../Test/TestFramework';
import IManagementDriver from '../../NativeDevice/Management/IManagementDriver';
import should from '../../Test/should';
import ManagementCapability from '../../NativeDevice/Management/ManagementCapability';
import { TestCase } from '@signageos/actions/dist/Device/Test/deviceTestActions';

export default async (nativeDriver: IManagementDriver) => {
	return t.describe(TestCase.BATTERY, function* () {
		yield t.it('Should get battery status', async () => {
			if (!(await nativeDriver.managementSupports(ManagementCapability.BATTERY_STATUS))) {
				t.skip(`The device does not provide "${ManagementCapability[ManagementCapability.BATTERY_STATUS]}" capability`);
			}

			const batteryStatus = await nativeDriver.batteryGetStatus();
			should(batteryStatus.percentage).be.greaterThanOrEqual(0);
			should(batteryStatus.percentage).be.lessThanOrEqual(100);
			should(batteryStatus.chargeType).be.oneOf('AC', 'NONE', 'USB');
			should.exist(batteryStatus.isCharging);
			should.exist(batteryStatus.lastChargingTime);
		});
	});
};
