import * as t from './../../Test/TestFramework';
import IManagementDriver from '../../NativeDevice/Management/IManagementDriver';
import should from '../../Test/should';
import ManagementCapability from '../../NativeDevice/Management/ManagementCapability';
import { TestCase } from '@signageos/actions/dist/Device/Test/deviceTestActions';

export default async (nativeDriver: IManagementDriver) => {
	return t.describe(TestCase.AUDIO, function* () {
		yield t.it('Should set the volume', async () => {
			if (!(await nativeDriver.managementSupports(ManagementCapability.SET_VOLUME))) {
				t.skip(`The device does not provide "${ManagementCapability[ManagementCapability.SET_VOLUME]}" capability`);
			}

			const originalVolume = await nativeDriver.getVolume();
			should(originalVolume).be.greaterThanOrEqual(0);
			should(originalVolume).be.lessThanOrEqual(100);
			await nativeDriver.setVolume(10);
			should(await nativeDriver.getVolume()).equal(10);
			await nativeDriver.setVolume(originalVolume);
		});
	});
};
