import { RsaKeyPairData, SecretStorage } from './SecretStorage';

export default class DefaultSecretStorage implements SecretStorage {
	constructor(private storage: Storage) {}

	public async saveKeyPair(name: string, keyPair: RsaKeyPairData) {
		const stringified = JSON.stringify(keyPair);
		this.storage.setItem(name, stringified);
	}

	public async getKeyPair(name: string): Promise<RsaKeyPairData | null> {
		const stringified = this.storage.getItem(name);
		if (!stringified) {
			return null;
		}
		return JSON.parse(stringified);
	}
}
