import { MonitoringLogData } from '@signageos/common-types/dist/Device/MonitoringLog/MonitoringLogData';
import { createDeviceTelemetrySaga } from '../Device/Telemetry/deviceTelemetrySagas';
import { DeviceTelemetryType } from '@signageos/common-types/dist/Device/Telemetry/DeviceTelemetryType';
import Responsibility from '../../Feature/Responsibility';
import { DeviceFeatureFlag } from '@signageos/common-types/dist/Device/FeatureFlag';

export const telemetryFeatureFlagsSaga = createDeviceTelemetrySaga(
	DeviceTelemetryType.FEATURE_FLAGS,
	Responsibility.TELEMETRY,
	[],
	getSupportedFeatureFlags,
);

export async function getSupportedFeatureFlags() {
	const featureFlags: MonitoringLogData[DeviceTelemetryType.FEATURE_FLAGS] = {
		supported: [DeviceFeatureFlag.ScreenshotCapture],
	};

	return featureFlags;
}
